# User Stories (Gherkin) — *Excavation of Days* (index.html)

> These user stories are derived **only** from the behavior and UI elements implemented in `index.html`.  
> They describe what a user can do through the interface and what outcomes the app provides.

---

## Feature: View calendar by year(s)

### Background
Given the app is open in a browser

### Scenario: User views a single selected year
Given the year range is configured
When the user adjusts the "Year" slider to a specific year
Then the calendar renders only that selected year
And the year label shows the selected year

### Scenario: User toggles between showing one year and showing all years in the current range
Given a start year and end year range is configured
When the user clicks the "Show all years" button
Then the calendar renders all years from end year down to start year
And the year label shows the range "start–end"
When the user clicks the toggle again
Then the calendar renders only the currently selected year
And the year label shows the selected year

### Scenario: User sets a custom year range
When the user enters a number in "Start year"
And the user enters a number in "End year"
And the user clicks "Apply"
Then the calendar range updates to show only years within the provided bounds
And the year slider min and max update to match the range
And a note shows "Showing start–end"

### Scenario: User enters the range years reversed and the app normalizes them
When the user enters a larger year in "Start year" than in "End year"
And the user clicks "Apply"
Then the app swaps the years internally so that start year is less than or equal to end year
And the calendar shows the normalized range

---

## Feature: Select and manage a workspace folder

### Background
Given the browser supports the File System Access API

### Scenario: User is prompted to pick a workspace when starting for the first time
Given no workspace has been saved in the browser
When the user clicks "New story"
Then the browser prompts the user to choose a folder (workspace)
And the app uses the selected folder for saving stories and notes

### Scenario: User switches to a different workspace
Given a workspace is already selected
When the user clicks "Switch workspace"
Then the browser prompts the user to choose a folder
And the app uses the new folder as the active workspace

### Scenario: User sees a gate to continue with a previously saved workspace
Given the app previously saved a workspace in this browser
When the app loads
Then a "Saved workspace found" gate is shown
And the gate offers actions "Continue" and "Switch workspace"

### Scenario: User continues with the saved workspace
Given the saved workspace gate is shown
When the user clicks "Continue"
Then the saved workspace is used as the active workspace
And the gate is hidden
And the stories list is loaded from that workspace

### Scenario: User chooses a different workspace from the gate
Given the saved workspace gate is shown
When the user clicks "Switch workspace"
Then the browser prompts the user to pick a new workspace folder
And the gate is hidden
And the stories list is loaded from the newly selected workspace

### Scenario: User is informed when the browser does not support direct folder saving
Given the browser does not support the File System Access API
When the app loads
Then the app indicates that notes will download instead of being saved directly

---

## Feature: Create a new story

### Background
Given a workspace is selected

### Scenario: User opens the Create New Story dialog
When the user clicks "New story"
Then a "Create new story" dialog is shown
And the dialog includes a "Story name" input
And the dialog includes "Story encryption (optional)" radio choices: "Plain JSON" and "Encrypted"

### Scenario: User creates a story as Plain JSON
Given the Create New Story dialog is open
When the user enters a valid story name
And the user selects "Plain JSON"
And the user clicks "Create"
Then a story folder with that name is created in the workspace
And story settings are saved with encryption disabled
And the new story becomes the active story

### Scenario: User creates a story as Encrypted with a story key
Given the Create New Story dialog is open
When the user enters a valid story name
And the user selects "Encrypted"
Then encryption fields are shown including:
  | Field | Behavior |
  | Key hint | optional text |
  | Story key | password input with a "Show" toggle |
  | Remember for this session | checkbox |
When the user enters a non-empty story key
And the user clicks "Create"
Then story settings are saved with encryption enabled and a generated salt
And the story key is cached for immediate use in the current session
And if "Remember for this session" is checked, the passphrase is stored for this session

### Scenario: User is prevented from creating an encrypted story when crypto is unavailable
Given the Create New Story dialog is open
And the user selects "Encrypted"
And Web Crypto is not available in this browser environment
When the user clicks "Create"
Then the app shows an error indicating encryption cannot be used
And the story is not created as encrypted

### Scenario: Story name is sanitized for filesystem compatibility
Given the Create New Story dialog is open
When the user enters a story name containing forbidden filename characters
And the user clicks "Create"
Then the app replaces forbidden characters with "-"
And uses the sanitized story name for the folder

---

## Feature: View and select stories

### Background
Given a workspace is selected

### Scenario: User sees a list of story folders
When the app loads stories from the workspace
Then the user sees a list of stories
And each story row includes a radio selector
And each story row shows a subtitle indicating whether the story is encrypted and whether it is unlocked

### Scenario: User activates a story
Given at least one story exists
When the user selects a story's radio button
Then that story becomes the active story
And the calendar is re-rendered
And the app scans the story folder for note files

### Scenario: Active story status is displayed
Given a story is active
When the app finishes scanning notes
Then the app status line indicates:
  | If story is encrypted | "Encrypted (locked/unlocked)" plus counts of decrypted and locked notes |
  | If story is not encrypted | number of notes found |

---

## Feature: Rescan active story notes

### Background
Given a story is active

### Scenario: User rescans the active story folder
When the user clicks "Rescan active story"
Then the app rescans note files in the active story folder
And updates decrypted/locked counts in the status line
And updates calendar cell styling accordingly

---

## Feature: Reset app state

### Scenario: User resets the app (forget workspace and active story)
When the user clicks "Reset"
Then the app asks for confirmation
When the user confirms
Then the app forgets the saved workspace and active story in this browser
And any remembered story/note passphrases for the session are cleared
And caches and tooltips are cleared
And the UI returns to "Click “New story” to start."

---

## Feature: Open a day and edit a note

### Background
Given a story is active

### Scenario: User opens the note dialog by clicking a day cell
When the user clicks a day cell in the calendar
Then a note dialog opens for that date
And the dialog shows the ISO date as title
And the dialog shows the weekday as hint
And the editor contains:
  | Control | Description |
  | Text area | for writing the day's note |
  | Color fieldset | radio options including "Unspecified" |
  | Tarot selector | radio lists for Major/Minor Arcana |
  | Encryption section | story unlock and note override options |
And the dialog shows save context as "Saving in story: <story> as <date>.json"

### Scenario: User loads an existing plaintext note
Given a plaintext note file exists for the selected date
When the user opens that date
Then the note text is populated
And the selected color is applied
And the selected tarot card is applied
And the status indicates the note was loaded

### Scenario: User opens a date that has no note file
Given no note file exists for the selected date
When the user opens that date
Then the editor is empty with default selections
And the status indicates no saved file exists yet

---

## Feature: Save notes (plaintext, story-encrypted, or note-encrypted)

### Background
Given a story is active
And the note dialog is open for a selected date

### Scenario: User saves a plaintext note in a non-encrypted story
Given story encryption is disabled
When the user writes text and selects options
And the user clicks "Save"
Then a JSON file named "YYYY-MM-DD.json" is saved in the active story folder
And the file contains plaintext note fields including date, note, color, tarot, updatedAt
And the calendar cell updates its color styling

### Scenario: User saves a note in a story with story encryption enabled
Given story encryption is enabled
And the story is unlocked
When the user clicks "Save"
Then the note file is saved as an encrypted envelope with scope "story"
And the calendar cell updates its styling (based on decrypted cache)

### Scenario: User is prompted to unlock the story when saving into an encrypted story
Given story encryption is enabled
And the story is locked
When the user clicks "Save"
Then the app requests the story be unlocked before saving
And saving does not complete until the story is unlocked

### Scenario: User enables note-specific override encryption and saves
Given the user checks "Use note-specific key (override)"
And the user enters a non-empty note key
When the user clicks "Save"
Then the note is saved as an encrypted envelope with scope "note"
And the envelope includes salt, iv, ciphertext, iterations, and optional keyHint
And if "Remember for this session" is checked, the note passphrase is stored for the session

### Scenario: User is blocked from saving note override without a key
Given the user checks "Use note-specific key (override)"
And the note key input is empty
When the user clicks "Save"
Then the app shows an error status requesting a note key
And the note is not saved

### Scenario: Browser without FS API downloads the note instead of saving into folder
Given the browser does not support File System Access API
When the user clicks "Save"
Then the app triggers a file download named "YYYY-MM-DD.json"
And the status indicates the note was downloaded and must be moved manually

---

## Feature: Unlock and lock stories

### Background
Given a story is active
And story encryption is enabled

### Scenario: User unlocks the story from the Stories panel
Given the story is locked
When the user clicks "Unlock story"
Then a dialog opens in "unlock-story" mode
And note editor fields are hidden
And the user can enter a story key in a password field with "Show" toggle
And "Unlock story" button stays disabled until the key input is non-empty

### Scenario: Story unlock succeeds with correct key
Given the story unlock dialog is open
When the user enters the correct story key
And the user clicks "Unlock story"
Then the story becomes unlocked for the session
And the story unlock area is hidden
And notes are rescanned and decrypted when possible
And the app status indicates the story is unlocked

### Scenario: Story unlock fails with incorrect key
Given the story unlock dialog is open
When the user enters an incorrect story key
And the user clicks "Unlock story"
Then the app shows "Wrong story key (or decryption failed)"
And the story remains locked

### Scenario: User locks an unlocked story
Given the story is unlocked
When the user clicks "Lock story"
Then the story key is removed from cache
And any remembered story passphrase in session storage is removed
And decrypted note cache is cleared
And all tooltips are cleared
And the note dialog (if open) is closed to prevent plaintext lingering
And the story becomes locked

---

## Feature: Disable story encryption (decrypt story-scope notes)

### Background
Given a story is active
And story encryption is enabled

### Scenario: User disables encryption after unlocking the story
Given the story is unlocked
When the user clicks "Disable encryption"
Then the app asks for confirmation
When the user confirms
Then each note encrypted with scope "story" is decrypted and rewritten as plaintext JSON
And notes encrypted with scope "note" remain encrypted and unchanged
And the story settings are saved with encryption disabled
And the story is locked (key cleared) after disabling
And the app rescans notes and updates the UI

### Scenario: User cannot disable encryption while the story is locked
Given the story is locked
When the user clicks "Disable encryption"
Then the app requests unlocking the story first

### Scenario: Disable encryption aborts if any story note cannot be decrypted
Given the story is unlocked
And at least one story-scope encrypted note cannot be decrypted or rewritten
When the user disables encryption
Then the app reports an error and keeps story encryption enabled

---

## Feature: Enable story encryption (encrypt all existing plaintext notes)

### Background
Given a story is active
And story encryption is disabled

### Scenario: User enables story encryption for an unencrypted story
When the user clicks "Enable encryption"
Then a "Story encryption" dialog opens
And the user can enter a story key (password) with a "Show" toggle
And the user can enter an optional key hint
And the confirm button is disabled until the story key is non-empty

### Scenario: Enabling encryption encrypts all existing plaintext notes
Given the Enable encryption dialog is open
And the user enters a story key
When the user clicks "Enable encryption"
Then the app generates a new salt and updates story settings to encryption enabled
And all existing plaintext note files are rewritten as story-scope encrypted envelopes
And any note-specific (scope "note") encrypted files are left unchanged
And the story becomes unlocked immediately in the same session
And the app rescans notes and updates calendar styling

### Scenario: Enable encryption fails if crypto is unavailable
Given Web Crypto is unavailable
When the user attempts to enable encryption
Then the app shows an error status and does not enable encryption

---

## Feature: Change story key (rotate key for story-scope notes)

### Background
Given a story is active
And story encryption is enabled

### Scenario: User changes the story key when the story is unlocked
Given the story is unlocked
When the user clicks "Change story key"
Then a dialog opens asking for a new story key and optional hint
And the confirm button is disabled until a non-empty key is entered
When the user confirms
Then all notes encrypted with scope "story" are decrypted using the old key and re-encrypted using the new key
And notes encrypted with scope "note" are not modified
And story settings are updated with a new salt and hint
And the story remains unlocked with the new key in cache
And the app rescans notes and updates the UI

### Scenario: User cannot change the story key while the story is locked
Given the story is locked
When the user clicks "Change story key"
Then the button is disabled
And the user must unlock the story first to rotate the key

---

## Feature: Unlock a note encrypted with a note-specific key (override)

### Background
Given a story is active
And a note file exists for a date with encryption scope "note"

### Scenario: User is prompted for a note key when opening a note-encrypted day
When the user opens that date
Then note override is enabled in the UI
And the note key hint is shown (if present)
And the note key input is hidden characters by default
And the user can choose to show the key via a toggle
And the status indicates the note is locked and requires the note key

### Scenario: User unlocks a note with the correct note key
Given the note is locked with note-specific encryption
When the user enters the correct note key
And the user clicks "Unlock note"
Then the note content is displayed in the editor
And the note is cached as plaintext for this session
And if "Remember for this session" is checked, the note key is saved for the session
And the "Disable note encryption" button becomes available

### Scenario: User fails to unlock a note with an incorrect key
Given the note is locked with note-specific encryption
When the user enters an incorrect note key
And the user clicks "Unlock note"
Then the app shows "Wrong note key (or decryption failed)"
And the note remains locked

---

## Feature: Disable note-specific encryption (remove override)

### Background
Given a story is active
And the note dialog is open for a date whose file is encrypted with scope "note"
And the note is unlocked (plaintext is loaded)

### Scenario: User disables note-specific encryption when story encryption is disabled
Given story encryption is disabled
When the user clicks "Disable note encryption"
Then the app confirms the action
When the user confirms
Then the note file is rewritten as plaintext JSON
And note override is removed for that date
And any remembered note passphrase for that date is cleared
And the UI no longer shows the note as note-encrypted

### Scenario: User disables note-specific encryption when story encryption is enabled and unlocked
Given story encryption is enabled
And the story is unlocked
When the user clicks "Disable note encryption"
Then the note file is rewritten as scope "story" encrypted using the story key
And note override is removed for that date
And any remembered note passphrase for that date is cleared

### Scenario: User cannot disable note-specific encryption while story encryption is enabled but locked
Given story encryption is enabled
And the story is locked
When the user clicks "Disable note encryption"
Then the app requests unlocking the story first

---

## Feature: Navigate between days in the note dialog

### Background
Given the note dialog is open for a selected date

### Scenario: User opens the previous day
When the user clicks "← Previous day"
Then the dialog loads the previous calendar date
And updates the title and content accordingly

### Scenario: User opens the next day
When the user clicks "Next day →"
Then the dialog loads the next calendar date
And updates the title and content accordingly

---

## Feature: Move a note file to a different date

### Background
Given a story is active
And the note dialog is open for a date

### Scenario: User moves a note to another date
When the user clicks "Move"
Then the app prompts for a target date in "YYYY-MM-DD" format
When the user enters a valid target date
Then the underlying note file is moved to the new date filename
And the old file is removed
And the calendar styling is updated for both dates

### Scenario: User cancels the move prompt
When the user clicks "Move"
And the user cancels the prompt
Then no files are changed

### Scenario: User is warned before overwriting an existing note on the target date
Given a note file already exists for the target date
When the user attempts to move another note to that date
Then the app asks for overwrite confirmation
And if the user declines, the move is canceled

---

## Feature: Switch story from the note dialog

### Background
Given the note dialog is open

### Scenario: User returns to the Stories section
When the user clicks "Switch story"
Then the note dialog closes
And the Stories section is opened and scrolled into view

---

## Feature: Calendar cell styling based on note color

### Background
Given a story is active
And note files exist in the active story

### Scenario: Calendar cells reflect saved note color
When the app scans and loads plaintext or decrypted notes
Then each date with a known note sets its cell fill color based on the selected color
And the date number text color adapts for readability

---

## Feature: Note content tooltips (privacy-aware)

### Background
Given a story is active
And the calendar is rendered

### Scenario: Tooltip appears for dates with cached plaintext notes when allowed
Given the story is not encrypted
And a plaintext note exists for a date
When the user hovers the mouse over that day cell
Then a tooltip shows the note content (truncated if very long)

### Scenario: Tooltip appears for story-encrypted notes only after unlocking the story
Given the story is encrypted
And a note exists for a date encrypted with scope "story"
And the story is locked
When the user hovers that date
Then no tooltip is shown
When the user unlocks the story successfully
And the app rescans notes
Then hovering that date shows the tooltip

### Scenario: Tooltip is never shown for note-specific encrypted notes
Given a note exists for a date encrypted with scope "note"
When the user hovers that date
Then no tooltip is shown
And this remains true even if the note is unlocked in the session

---

## Feature: Tarot selection for a note

### Background
Given the note dialog is open

### Scenario: User selects "None" tarot card
When the user selects the tarot option "None"
Then no tarot card is associated with the note upon saving

### Scenario: User selects a Major Arcana card
When the user selects a Major Arcana radio option
Then the selected tarot label updates to show the card (with numeral)
And the choice is saved with the note

### Scenario: User selects a Minor Arcana card by suit and rank
When the user selects a Minor Arcana radio option
Then the selected tarot label updates to show the rank and suit
And the choice is saved with the note

---

## Feature: Password visibility toggles

### Scenario: User toggles visibility for story unlock key field
Given the story unlock UI is shown
When the user checks "Show" next to the story key input
Then the story key input displays as plain text
When the user unchecks it
Then the story key input masks the characters again

### Scenario: User toggles visibility for note override key field
Given note override UI is shown
When the user checks "Show" next to the note key input
Then the note key input displays as plain text
When the user unchecks it
Then the note key input masks the characters again

### Scenario: User toggles visibility in the Enable/Change story encryption dialog
Given the story encryption dialog is open
When the user checks "Show"
Then the story key input displays as plain text
When the user unchecks it
Then the story key input masks the characters again
